// Paramétrage du service completionStorage :
//   - "completed" SSi un score est affecté pour les assmntUa
//   - pas de commit auto sur un changement de valeur
scServices.completionStorage.getCurrentCompletionStatus = function(){
	let vApi;
	if(scServices.completionStorage._xIsAssmntUa){
		if(scServices.scorm2k4 && scServices.scorm2k4.isScorm2k4Active()) {
			vApi = scServices.scorm2k4.getScorm2k4API();
			return (vApi.GetValue("cmi.score.scaled")!=null && vApi.GetValue("cmi.score.scaled")!=="") ? "completed" : "incomplete" ;
		} else if(scServices.scorm12 && scServices.scorm12.isScorm12Active()) {
			vApi = scServices.scorm12.getScorm12API();
			return (vApi.LMSGetValue("cmi.core.score.raw")!=null && vApi.LMSGetValue("cmi.core.score.raw")!=="") ? "completed" : "incomplete" ;
		}
	}else
		return "completed";
}
scServices.completionStorage._SendDataOnSave = false;

// Paramétrage du service exitModeStorage:
//   - pas de commit auto sur un changement de valeur
scServices.exitModeStorage._SendDataOnSet = false;
scServices.exitModeStorage._SendDataOnTerminate = false;
//   - exit : "suspend" quand le parcours du SCO n'est pas complet, et "" (terminé) quand le parcours du SCO est complet
scServices.exitModeStorage.getExitMode = function(){
	return scServices.completionStorage.getCurrentCompletionStatus()==="completed" ? "" : "suspend" ;
}

// Paramétrage du service suspendDataStorage :
//   - pas de commit sur le changement de page des assmnts
scServices.suspendDataStorage._SendDataOnSave=false

// Paramétrage du service assmntMgr:
//   - pas de commit sur le changement de page des assmnts
scServices.assmntMgr._SendDataOnSave = false;
scOnLoads[scOnLoads.length] = {
	onLoad: function(){
		// Ajout d'un flag scServices.assmntMgr.review si cmi.mode = review.
		// Utilisé pour passer l'IHM en lecture seule (quiz, pages vues dans le menu, etc).
		if(scServices.scorm2k4 && scServices.scorm2k4.isScorm2k4Active()) {
			vApi = scServices.scorm2k4.getScorm2k4API();
			if(vApi.GetValue("cmi.mode")==="review") scServices.assmntMgr.review = true;
		} else if(scServices.scorm12 && scServices.scorm12.isScorm12Active()) {
			vApi = scServices.scorm12.getScorm12API();
			if(vApi.LMSGetValue("cmi.core.lesson_mode")==="review") scServices.assmntMgr.review = true;
		}
	},
	loadSortKey: "1scormMode"
}
